
# Análise Completa — ERP/PDV Desktop (Tkinter + SQLite)

**Escopo do que fiz agora:** extraí o zip, fiz _scan_ estático (≈2.1k arquivos), compilei Python para detectar _SyntaxErrors_, identifiquei entradas, dependências prováveis, esquemas de banco, e sinais de funcionalidades (PIX, QR Code, câmera, vendas/estoque). Não executei interface gráfica (ambiente sem GUI).

---

## Resultado rápido
- ✅ **Compilação**: Sem *SyntaxError* nos 400 principais arquivos analisados.
- ✅ **Módulos principais**: `erp_pdv_tk.py`, `vendas.py`, `estoque.py`, `fees.py`, `pix_config*.py`, `seed_db.py`, `reset_admin.py`.
- ✅ **Banco**: SQLite com tabelas `users`, `permissions`, `user_permissions`, `settings`, `products`, `customers`, `sales`, `sale_items`.
- ✅ **Funcionalidades detectadas**: Tkinter GUI, vendas, estoque, geração de QR Code, integração PIX com **polling**, leitura por câmera (**OpenCV + pyzbar**), exportação/relatórios (marcas de `report/pdf`).
- ⚠️ **Cóps duplicadas**: arquivos `* - Copia.py` podem confundir (mantenha apenas a versão oficial).
- ⚠️ **.venv dentro do projeto**: aumenta o zip e causa conflitos; ideal **excluir do repositório**.
- ⚠️ **Requisitos**: não vi `requirements.txt` confiável na raiz (gerei um sugerido).

Arquivos úteis para você baixar:
- **Resumo do scan**: [erp_pdv_tk_quickscan.json](sandbox:/mnt/data/erp_pdv_tk_quickscan.json)
- **Requisitos sugeridos**: [requirements (sugerido)](sandbox:/mnt/data/erp_pdv_tk_suggested_requirements.txt)

---

## Estrutura (topo)
Uma prévia da árvore (profundidade ≤ 3) está no JSON acima. Os módulos relevantes estão em `erp_pdv_tk/`.

---

## Dependências prováveis (detectadas por import)
- **GUI**: `tkinter`
- **Câmera & Código de barras/QR**: `opencv-python (cv2)`, `pyzbar`, `qrcode`, `Pillow`
- **Relatórios/Gráficos**: `reportlab`, `matplotlib`, `openpyxl`
- **HTTP/PIX**: `requests`
- **Numérico**: `numpy`

> Baixe: [requirements (sugerido)](sandbox:/mnt/data/erp_pdv_tk_suggested_requirements.txt)

---

## Entradas e módulos
- `erp_pdv_tk/erp_pdv_tk.py` — base do app (users/permissions/settings).
- `erp_pdv_tk/vendas.py` — fluxo do PDV, PIX (criação/consulta), QR Code, métodos de pagamento (dinheiro/cartão/PIX), câmera.
- `erp_pdv_tk/estoque.py` — cadastro e movimentação de produtos (usa câmera para leitura de código).
- `erp_pdv_tk/fees.py` — configuração de taxas da plataforma.
- `erp_pdv_tk/pix_config*.py` — configurações específicas de PSP (Mercado Pago etc.).
- `erp_pdv_tk/seed_db.py` — *seed* com usuários, produtos, clientes, vendas.

---

## Banco de Dados (SQLite)
Tabelas detectadas por `CREATE TABLE`:
- `users`, `permissions`, `user_permissions`, `settings` (módulo base)
- `products` (estoque)
- `sales`, `sale_items` (vendas)
- `customers` (via seeds)

**Recomendação:** usar `DECIMAL`/`NUMERIC` com escala fixa para valores monetários; validar `NOT NULL` e *foreign keys* (`PRAGMA foreign_keys = ON`).

---

## PIX & Polling
No `vendas.py`:
- Rotinas de **criação de cobrança** e **consulta de status** (polling via `requests`).
- **QR Code** integrado.
- Estrutura para abstrair PSP (há variações `pix_config*.py`).

**Melhorias sugeridas:**
1. **Idempotência** por `txid` + tabela `pix_charges` (unicidade).
2. **Assinatura** do webhook (quando habilitar) e verificação de autenticidade.
3. **Estados** bem definidos (`created` → `pending` → `approved`/`expired`/`canceled`).
4. **Retries com backoff** e `timeout` configurado no `requests`.
5. **Logs estruturados** (JSON) para auditoria.

---

## Leitor por Câmera
- Uso de `cv2.VideoCapture` + `pyzbar` presente em `vendas.py` e `estoque.py`.
- **Dica Windows**: testar backends `CAP_DSHOW` **e** `CAP_MSMF`, com *fallback* e lista de câmeras.

---

## Relatórios
- Marcas de geração de relatório/PDF encontradas. Se usar `reportlab`, padronizar layout A4 e 80mm (térmica), e salvar também em PDF para impressoras padrão.

---

## Qualidade & Organização
- ✅ Sem *SyntaxError* (amostra verificada).
- ⚠️ Pastas de ambiente (`.venv/`) e **cópias** de arquivos (`* - Copia.py`) devem sair do controle de versão.
- ⚠️ Consolidar **um** ponto de entrada (ex.: `python -m erp_pdv_tk`) e movê-lo para `src/` ou `app/`.

**Ações rápidas recomendadas:**
1. Remover `.venv/` do zip/repo (`.gitignore`).
2. Deletar `* - Copia.py` (ou mover para `archive/`).
3. Criar `requirements.txt` (use o sugerido como base).
4. Adicionar `README.md` com **comandos de execução e seed**.

---

## Como testar localmente (passo a passo)
```bash
# 1) Python 3.11+ recomendado (Windows 10/11)
python -m venv .venv
.venv\Scriptsctivate

# 2) Dependências
pip install -r erp_pdv_tk_suggested_requirements.txt

# 3) Rodar seed (cria DB e dados)
cd erp_pdv_tk/erp_pdv_tk
python seed_db.py --fresh --with-sales 30

# 4) Iniciar app principal (Tkinter)
python erp_pdv_tk.py

# 5) Testar PDV
python vendas.py
# - Vendas rápidas (dinheiro/PIX/cartão)
# - Geração de QR Code (PIX)
# - Polling do pagamento
# - Leitor de câmera (se disponível)

# 6) Estoque
python estoque.py
```

> Se a câmera não abrir: instale/atualize drivers, teste backends MSMF/DSHOW, e rode como Administrador.

---

## Próximos passos sugeridos (prioridade)
1. **Pagamentos**: tabela `pix_charges` + idempotência + assinaturas (webhook) + retries.
2. **Dinheiro decimal**: trocar `float` por `Decimal`/`NUMERIC(12,2)` em toda a camada de persistência.
3. **Permissões**: perfis (`admin`, `gerente`, `caixa`) com bloqueio de desconto/cancelamento/sangria.
4. **Relatórios**: recibo térmico 80mm + PDF A4; ranking de vendas e produtos; export Excel.
5. **UX PDV**: atalhos (F2 nova venda, F4 desconto, F11 maximizar, F12 restaurar), foco no campo de código, quebra automática de linha.
6. **Código**: dividir `vendas.py` em camadas (service/repo/gui), testes de unidade para cálculos e fluxo de estados.
7. **Distribuição**: `pyinstaller` para gerar `.exe` portátil (com `--add-data` de ícones/fonts).

---

## Artefatos gerados
- Quick scan JSON: [abrir](sandbox:/mnt/data/erp_pdv_tk_quickscan.json)
- Requirements sugerido: [baixar](sandbox:/mnt/data/erp_pdv_tk_suggested_requirements.txt)

---

*Relatório gerado automaticamente nesta análise.*
