@echo off 
setlocal EnableExtensions EnableDelayedExpansion

REM ============================================================
REM Configurações
REM ============================================================
set "APP=erp_pdv_tk.py"

REM Versão alvo do Python
set "PY_MAJOR=3"
set "PY_MINOR=12"

REM (Fallback) URL do instalador oficial x64 do Python 3.12
set "PY_VERSION_FULL=3.12.7"
set "PY_URL=https://www.python.org/ftp/python/%PY_VERSION_FULL%/python-%PY_VERSION_FULL%-amd64.exe"
set "PY_TMP=%TEMP%\python-%PY_VERSION_FULL%-amd64.exe"

REM Caminho típico de instalação por usuário (sem admin)
set "PY_USER_DIR=%LocalAppData%\Programs\Python\Python%PY_MAJOR%%PY_MINOR%"
set "PY_USER_EXE=%PY_USER_DIR%\python.exe"

REM Log de dependências
set "LOG=%TEMP%\deps_install_%RANDOM%.log"

REM ============================================================
REM Ir para o diretório deste .bat
REM ============================================================
pushd "%~dp0"

echo.
echo [1/9] Verificando Python %PY_MAJOR%.%PY_MINOR%...
py -%PY_MAJOR%.%PY_MINOR% -c "import sys; print(sys.version)" >NUL 2>&1
if %ERRORLEVEL% EQU 0 (
    echo    - Python %PY_MAJOR%.%PY_MINOR% encontrado via 'py'.
    goto :RUN_DEPS
)

REM Tentativa direta via caminho do usuario
if exist "%PY_USER_EXE%" (
    echo    - Python encontrado em "%PY_USER_EXE%".
    goto :RUN_DEPS
)

echo    - Python %PY_MAJOR%.%PY_MINOR% NAO encontrado.

REM ============================================================
REM Tentar instalar via winget (se existir)
REM ============================================================
echo.
echo [2/9] Verificando winget...
winget --version >NUL 2>&1
if %ERRORLEVEL% EQU 0 (
    echo    - winget encontrado. Instalando Python %PY_MAJOR%.%PY_MINOR% via winget...
    REM ID oficial: Python.Python.3.12
    winget install --id Python.Python.%PY_MINOR% -e --source winget ^
        --scope user --silent --disable-interactivity ^
        --accept-package-agreements --accept-source-agreements
) else (
    echo    - winget NAO encontrado. Usando instalador oficial como fallback...
    goto :INSTALL_FALLBACK
)

REM Após tentativa com winget, verificar novamente
echo.
echo [3/9] Validando instalacao do Python...
py -%PY_MAJOR%.%PY_MINOR% -c "import sys; print(sys.version)" >NUL 2>&1 && goto :RUN_DEPS

if exist "%PY_USER_EXE%" (
    echo    - Python encontrado em "%PY_USER_EXE%".
    goto :RUN_DEPS
)

echo    - Nao foi possivel validar o Python apos o winget.
echo      Tentando instalacao via instalador oficial...
goto :INSTALL_FALLBACK

REM ============================================================
REM Fallback: baixar instalador oficial e instalar silenciosamente
REM ============================================================
:INSTALL_FALLBACK
echo.
echo [4/9] Baixando instalador oficial do Python %PY_VERSION_FULL%...
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "try { Invoke-WebRequest -Uri '%PY_URL%' -OutFile '%PY_TMP%' -UseBasicParsing; exit 0 } catch { exit 1 }"
if %ERRORLEVEL% NEQ 0 (
    echo    - ERRO: Falha ao baixar %PY_URL%
    echo      Verifique sua internet ou baixe manualmente e rode o instalador.
    echo.
    pause
    goto :FAIL
)

echo    - Instalando Python em modo silencioso (aguarde)...
REM start /wait garante que o .bat continue apenas apos o instalador terminar
start "" /wait "%PY_TMP%" /quiet PrependPath=1 Include_test=0 InstallAllUsers=0
set "PY_INSTALL_EXIT=%ERRORLEVEL%"

del /q "%PY_TMP%" >NUL 2>&1

if %PY_INSTALL_EXIT% NEQ 0 (
    echo    - ERRO: Instalador retornou codigo %PY_INSTALL_EXIT%.
    echo.
    pause
    goto :FAIL
)

REM Verificar novamente
echo.
echo [5/9] Validando instalacao do Python...
REM 1) Tentar via 'py' launcher
py -%PY_MAJOR%.%PY_MINOR% -c "import sys; print(sys.version)" >NUL 2>&1 && goto :RUN_DEPS

REM 2) Tentar caminho direto no perfil do usuario
if exist "%PY_USER_EXE%" (
    echo    - Python encontrado em "%PY_USER_EXE%".
    goto :RUN_DEPS
)

REM 3) Tentar 'python' no PATH
where python >NUL 2>&1
if %ERRORLEVEL% EQU 0 (
    for /f "delims=" %%P in ('where python') do (
        "%%~fP" -c "import sys; print(sys.version)" >NUL 2>&1 && goto :RUN_DEPS
    )
)

echo    - ERRO: Python ainda nao disponivel neste terminal.
echo      Feche e reabra a janela, ou reinicie o PC, e rode este .bat novamente.
echo.
pause
goto :FAIL

REM ============================================================
REM  DEPENDÊNCIAS
REM ============================================================
:RUN_DEPS
echo.
echo [6/9] Preparando instalacao/atualizacao das dependencias...
set "PIPCMD="

REM 1) .venv local
if exist ".venv\Scripts\python.exe" (
  set "PIPCMD=.venv\Scripts\python.exe -m pip"
)

REM 2) py launcher exato (3.12)
if not defined PIPCMD (
  where py >nul 2>&1
  if %ERRORLEVEL%==0 (
    py -%PY_MAJOR%.%PY_MINOR% -m pip --version >nul 2>&1 && set "PIPCMD=py -%PY_MAJOR%.%PY_MINOR% -m pip"
    if not defined PIPCMD ( py -3 -m pip --version >nul 2>&1 && set "PIPCMD=py -3 -m pip" )
    if not defined PIPCMD ( py -m pip --version >nul 2>&1 && set "PIPCMD=py -m pip" )
  )
)

REM 3) python do PATH
if not defined PIPCMD (
  where python >nul 2>&1 && set "PIPCMD=python -m pip"
)

REM 4) python recém-instalado no perfil do usuario
if not defined PIPCMD (
  if exist "%PY_USER_EXE%" set "PIPCMD=""%PY_USER_EXE%"" -m pip"
)

if not defined PIPCMD (
  echo [ERRO] Python/pip nao encontrado. Instale Python 3.12+.
  echo.
  pause
  goto :FAIL
)

echo [INFO] Usando: %PIPCMD%
echo [INFO] Atualizando pip/setuptools/wheel...
%PIPCMD% install --upgrade pip setuptools wheel >> "%LOG%" 2>&1

echo.
echo [7/9] Instalando/atualizando dependencias...
%PIPCMD% install ^
 "numpy>=1.26" ^
 "opencv-python>=4.9" ^
 "pyzbar>=0.1.9" ^
 "Pillow>=10.0" ^
 "qrcode>=7.4" ^
 "requests>=2.31" ^
 "reportlab>=4.0" ^
 "matplotlib>=3.8" ^
 "openpyxl>=3.1" >> "%LOG%" 2>&1

if errorlevel 1 (
  echo.
  echo [ERRO] Falha ao instalar alguma dependencia. Veja o log:
  echo   "%LOG%"
  echo.
  type "%LOG%"
  echo.
  pause
  goto :FAIL
)

REM Detectar se houve instalacao/atualizacao
set "CHANGES="
set "SAT="
findstr /I /C:"Successfully installed" /C:"Installing collected packages" "%LOG%" >nul && set "CHANGES=1"
findstr /I /C:"Requirement already satisfied" "%LOG%" >nul && set "SAT=1"

echo.
if defined CHANGES (
  echo [OK] Dependencias instaladas/atualizadas com sucesso.
) else if defined SAT (
  echo [OK] Nada a instalar: todas as dependencias ja estavam presentes.
) else (
  echo [OK] Processo de dependencias concluido. (Veja o log se desejar)
)
echo Log: "%LOG%"

REM ============================================================
REM  ABRIR O APLICATIVO
REM ============================================================
:RUN_APP
echo.
echo [8/9] Preparando para abrir o aplicativo...

if not exist "%APP%" (
  echo [ERRO] Nao encontrei "%APP%" nesta pasta:
  echo        %cd%
  echo.
  pause
  goto :END
)

set "USED_INTERPRETER="

REM 1) Prioriza Python da .venv local
if exist ".venv\Scripts\python.exe" (
  set "USED_INTERPRETER=.venv\Scripts\python.exe"
  echo Iniciando com !USED_INTERPRETER! ...
  "!USED_INTERPRETER!" "%APP%"
  goto :AFTER_APP
)

REM 2) Tenta o py launcher (3.12 -> 3.x -> default)
where py >nul 2>&1
if %ERRORLEVEL%==0 (
  set "USED_INTERPRETER=py -%PY_MAJOR%.%PY_MINOR%"
  echo Iniciando com !USED_INTERPRETER! ...
  py -%PY_MAJOR%.%PY_MINOR% "%APP%" && goto :AFTER_APP
  set "USED_INTERPRETER=py -3"
  echo Iniciando com !USED_INTERPRETER! ...
  py -3 "%APP%" && goto :AFTER_APP
  set "USED_INTERPRETER=py"
  echo Iniciando com !USED_INTERPRETER! ...
  py "%APP%" && goto :AFTER_APP
)

REM 3) Tenta "python" do PATH
where python >nul 2>&1
if %ERRORLEVEL%==0 (
  for /f "delims=" %%P in ('where python') do (
    set "USED_INTERPRETER=%%~fP"
    echo Iniciando com !USED_INTERPRETER! ...
    "%%~fP" "%APP%" && goto :AFTER_APP
  )
)

REM 4) Tenta python recém-instalado no perfil do usuario
if exist "%PY_USER_EXE%" (
  set "USED_INTERPRETER=%PY_USER_EXE%"
  echo Iniciando com !USED_INTERPRETER! ...
  "%PY_USER_EXE%" "%APP%" && goto :AFTER_APP
)

echo.
echo [ERRO] Python nao encontrado ou falha ao iniciar o ERP.
echo - Instale o Python 3.12+ (Microsoft Store ou https://www.python.org).
echo - Ou crie/ative a virtualenv local:  py -3.12 -m venv .venv
echo   e depois instale dependencias:     .venv\Scripts\pip install -r requirements.txt
echo.
pause
goto :END

:AFTER_APP
echo.
echo [INFO] ERP/PDV finalizado. (Interpreter usado: !USED_INTERPRETER!)
echo.

:END
echo [9/9] Processo concluido.

REM ====== CRIAR ATALHO NA ÁREA DE TRABALHO (robusto, com ícone) ======
set "WORKDIR=%~dp0"
set "TARGET=%~f0"
set "ICON=%WORKDIR%assets\icone2.ico"
set "SHORTCUT=%UserProfile%\Desktop\FabricaDigitalShop.lnk"

powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "$sc  = New-Object -ComObject WScript.Shell;" ^
  "$lnk = $sc.CreateShortcut('%SHORTCUT%');" ^
  "$lnk.TargetPath = '%TARGET%';" ^
  "$lnk.WorkingDirectory = '%WORKDIR%';" ^
  "$lnk.WindowStyle = 1;" ^
  "if (Test-Path '%ICON%') { $lnk.IconLocation = '%ICON%' }" ^
  "$lnk.Description = 'FabricaDigitalShop — abrir ERP/PDV';" ^
  "$lnk.Save()" >NUL 2>&1

if exist "%SHORTCUT%" (
  echo [OK] Atalho criado/atualizado: %SHORTCUT%
) else (
  echo [AVISO] Nao foi possivel criar o atalho. (PowerShell/COM indisponivel?)
)

echo.
echo Pressione qualquer tecla para fechar...
pause >nul
popd
exit /b 0

:FAIL
popd
exit /b 1
