# create_schema_nfce.py  (seguro e idempotente)
import sqlite3, sys

db = sys.argv[1] if len(sys.argv) > 1 else "erp.sqlite3"
con = sqlite3.connect(db)
cur = con.cursor()

def table_exists(name: str) -> bool:
    row = cur.execute("SELECT 1 FROM sqlite_master WHERE type='table' AND name=?", (name,)).fetchone()
    return row is not None

def safe_alter(sql):
    try:
        cur.execute(sql)
    except Exception as e:
        msg = str(e).lower()
        if "duplicate column name" in msg or "already exists" in msg:
            pass  # coluna já existe: ok
        else:
            raise

# 1) Se a tabela 'sales' existir, adiciona 'status'; se não existir, apenas avisa.
if table_exists("sales"):
    safe_alter("ALTER TABLE sales ADD COLUMN status TEXT DEFAULT 'PENDENTE'")
else:
    print("[AVISO] Tabela 'sales' não encontrada neste banco. Pulando ALTER da coluna 'status'.")

# 2) Tabelas fiscais (sempre criadas se não existirem)
cur.execute("""
CREATE TABLE IF NOT EXISTS fiscal_config (
  id INTEGER PRIMARY KEY CHECK(id=1),
  mode TEXT NOT NULL CHECK(mode IN ('RECIBO','NFCE')),
  cnpj TEXT, ie TEXT, regime TEXT, uf TEXT,
  ambiente TEXT CHECK(ambiente IN ('homolog','prod')),
  csc_id TEXT, csc_token TEXT,
  cert_pfx BLOB, cert_password TEXT,
  serie INTEGER DEFAULT 1, numero INTEGER DEFAULT 1,
  updated_at TEXT
)""")

cur.execute("""
CREATE TABLE IF NOT EXISTS invoices (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  sale_id INTEGER NOT NULL,
  model TEXT NOT NULL CHECK(model IN ('NFCE')),
  chave TEXT, numero INTEGER, serie INTEGER,
  status TEXT NOT NULL CHECK(status IN ('pending','authorized','rejected','error')),
  protocolo TEXT, xml TEXT, pdf_path TEXT,
  created_at TEXT, authorized_at TEXT
)""")

cur.execute("""
CREATE TABLE IF NOT EXISTS invoice_items (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  invoice_id INTEGER NOT NULL,
  product_id INTEGER, description TEXT,
  ncm TEXT, cfop TEXT,
  qty REAL, unit TEXT, unit_price REAL, total REAL,
  tax_json TEXT
)""")

# 3) Garante linha de config fiscal id=1 (placeholder)
row = cur.execute("SELECT 1 FROM fiscal_config WHERE id=1").fetchone()
if not row:
    cur.execute("""
    INSERT INTO fiscal_config
    (id, mode, cnpj, ie, regime, uf, ambiente, csc_id, csc_token, cert_pfx, cert_password, serie, numero, updated_at)
    VALUES (1,'NFCE','','','','SP','homolog','','',NULL,'',1,1,datetime('now'))
    """)

con.commit(); con.close()
print("Schema fiscal criado/checado em", db)
