# debug_login.py — mostra onde está o DB e testa a senha do admin
import os, sqlite3
import erp_pdv_tk as app

db = app.get_db_path()
print("DB:", db)
print("ERP_PDV_DB =", os.environ.get("ERP_PDV_DB"))

conn = sqlite3.connect(db)
conn.row_factory = sqlite3.Row

row = conn.execute("SELECT * FROM users WHERE username='admin'").fetchone()
if not row:
    print("admin NAO existe nesse DB.")
else:
    print(f"admin existe: id={row['id']} active={row['active']} is_admin={row['is_admin']} must_change={row['must_change_password']}")
    ph = row["password_hash"]
    pref = str(ph).split("$",1)[0]
    print("hash prefix:", pref)
    print("check('admin'):", app.check_password("admin", ph))

    # prova de vida do algoritmo do app:
    fake = app.make_password("admin")
    print("algoritmo do app ok? (roundtrip):", app.check_password("admin", fake))

conn.close()
