🟦────────────────────────────────────────────────────────────────
**Manual do Usuário — FabricaDigitalShop - www.fabricadigitalshop.com - para suporte: fabricadigitalshop@gmail.com**
🟦────────────────────────────────────────────────────────────────

**Bem-vindo!** Este manual foi pensado para ser **simples, direto e prático** — ideal para **pequenos e médios comércios** que precisam vender rápido, controlar estoque e organizar o caixa **sem equipamentos caros**.

**Destaques importantes (vale ouro!)**
```
• Para imprimir recibos/notas NÃO é necessária impressora específica.
  → Funciona com QUALQUER impressora (térmica, jato de tinta, laser, A4).
  → Se quiser cupom no rolo (80mm), a térmica é opcional — não é obrigatória.

• Para ler código de barras NÃO é obrigatório um leitor dedicado.
  → Pode usar QUALQUER webcam com boa iluminação.
  → Dica: posicione o código a ~10–20 cm, centralize na imagem e mantenha firme.

• Menus desabilitados indicam falta de permissão. Peça ao Administrador.
• Atalhos: Manual (F1) • Relatórios (F11)
• Banco local: SQLite (erp_pdv.db)
```

🟧────────────────────────────────────────────────────────────────
**Sumário**
🟧────────────────────────────────────────────────────────────────
```
1. Visão Geral
2. Atalhos Principais
3. Menus da Tela Principal
   3.1 Módulos
       3.1.1 PDV (Vendas)
       3.1.2 Estoque
       3.1.3 Caixa (Abertura/Fechamento)
       3.1.4 Finanças (Taxas)
       3.1.5 Relatórios (F11)
   3.2 Fiscal
       3.2.1 Configurar Nota (NFC-e)
       3.2.2 Configurar Nome Nota/Recibo
   3.3 Admin
       3.3.1 Usuários
       3.3.2 Configuração PIX
   3.4 Conta
       3.4.1 Trocar Senha
       3.4.2 Sair
   3.5 Ajuda
4. Passo a Passo Rápido
5. Mensagens Comuns e Soluções
6. Boas Práticas e Backup
7. Permissões e Cargos
```

🟩────────────────────────────────────────────────────────────────
**1. Visão Geral**
🟩────────────────────────────────────────────────────────────────
```
• Aplicação desktop (Tkinter) com banco SQLite (arquivo .db local).
• Acesso por “permissões” e “cargos”: ADMIN, VENDEDOR, GERENTE,
  ESTOQUISTA, FINANCEIRO (você pode combinar ambos).
• Pensado para operação simples: vender, receber, imprimir e acompanhar.
```

🟪────────────────────────────────────────────────────────────────
**2. Atalhos Principais**
🟪────────────────────────────────────────────────────────────────
```
Ação                         Atalho   Onde
------------------------------------------------------
Abrir Manual do Usuário       F1      Qualquer tela
Abrir Relatórios              F11     Menu → Módulos

Dica: se o atalho não funcionar, verifique sua permissão.
```

🟥────────────────────────────────────────────────────────────────
**3. Menus da Tela Principal**
🟥────────────────────────────────────────────────────────────────

**3.1 Módulos**

**3.1.1 PDV (Vendas)**
```
Para registrar vendas com rapidez.

Como usar (6 passos):
  1) Módulos → PDV (Vendas)
  2) Buscar produto: código de barras, código interno ou nome
     • Sem leitor? Use a WEBCAM como leitor (funciona!)
  3) Informar quantidade e confirmar inclusão
  4) (Opcional) Aplicar desconto por item ou no total (se permitido)
  5) Selecionar forma de pagamento: Dinheiro / Cartão / PIX
  6) Concluir e imprimir recibo

Impressão SEM frescura:
  • Serve QUALQUER impressora (térmica, jato de tinta, laser, A4).
  • Cupom 80mm é preferência de layout, não exigência.

Requisitos: permissão PDV
Observação PIX: o nome do recebedor vem de “Configuração PIX”.
Se vazio, usa o “Nome do Estabelecimento” (Fiscal → Configurar Nome Nota/Recibo).
```

**3.1.2 Estoque**
```
Cadastro e movimentação (entrada, saída, ajuste) de produtos.

Recursos:
  • Produtos: nome, preço, código, unidade, NCM (quando aplicável)
  • Movimentações: Entrada (compra), Saída (venda/baixa), Ajuste (inventário)
  • Acompanhamento: níveis críticos e giro de estoque

Requisitos: permissão ESTOQUE
```

**3.1.3 Caixa (Abertura/Fechamento)**
```
Controle diário: abertura de caixa, suprimentos, sangrias e fechamento.

Fluxo típico:
  1) Abrir caixa com saldo inicial
  2) Registrar suprimentos (entradas) e sangrias (retiradas)
  3) Fechar conferindo Dinheiro / Cartões / PIX

Requisitos: permissão FINANCAS
```

**3.1.4 Finanças (Taxas)**
```
Defina as taxas por meio de pagamento e simule o líquido esperado.

Recursos:
  • Tabela de taxas por modalidade
  • Simulação por venda para projeção de recebíveis

Requisitos: permissão FINANCAS
```

**3.1.5 Relatórios (F11)**
```
Visão clara de vendas, estoque e caixa.

Filtros comuns:
  • Período, Operador, Forma de pagamento
Exemplos:
  • Vendas por período/forma, produtos mais vendidos, giro de estoque
  • Movimento de caixa: abertura, suprimentos, sangrias, fechamento

Requisitos: RELATORIOS | Atalho: F11
```

**3.2 Fiscal**

**3.2.1 Configurar Nota (NFC-e)**
```
Parâmetros exigidos pela SEFAZ do estado: CSC, série, ambiente (homologação/produção),
certificado quando aplicável. Sempre teste em homologação antes de ir para produção.

Requisitos: FISCAL_CONFIG (e FISCAL_EMIT para emitir, quando disponível)
```

**3.2.2 Configurar Nome Nota/Recibo**
```
Define os dados do recibo/nota:
  • Nome do Estabelecimento (também usado como fallback no PIX)
  • Endereço (linhas 1 e 2) e Cidade/UF
  • Documento (CNPJ/CPF)
Impacto: identidade do recibo e nome do recebedor no PIX, se não definido em PIX.
```

**3.3 Admin**

**3.3.1 Usuários**
```
Gerencie contas, cargos e permissões.

Pode:
  • Criar usuário com senha inicial (forçar troca no 1º login, se desejar)
  • Editar dados (nome, ativo/inativo, admin)
  • Atribuir cargos (Admin, Vendedor, Gerente, Estoquista, Financeiro)
  • Conceder permissões específicas além do cargo
  • Redefinir senha
  • Ativar/Desativar acesso

Proteções:
  • Não é permitido excluir o usuário “admin”
  • Não é permitido excluir o último administrador ativo

Requisitos: ADMIN_USERS ou Admin
```

**3.3.2 Configuração PIX**
```
Cadastre chave PIX, nome do recebedor e parâmetros do QR Code.
Se o nome estiver vazio aqui, o sistema usa o “Nome do Estabelecimento” (Fiscal).

Requisitos: PIX_CONFIG (ou Admin)
```

**3.4 Conta**

**3.4.1 Trocar Senha**
```
Altere a senha do usuário logado (digite duas vezes). Prefira senhas fortes.
```

**3.4.2 Sair**
```
Encerra a sessão e retorna à tela de login.
```

**3.5 Ajuda**
```
Manual do Usuário (F1): abre este documento.
```

🟨────────────────────────────────────────────────────────────────
**4. Passo a Passo Rápido**
🟨────────────────────────────────────────────────────────────────

**4.1 Venda Rápida no PDV**
```
1) Abrir PDV (Menu Módulos)
2) Incluir itens (código de barras • código interno • nome)
   • Sem leitor? Use WEBCAM como leitor.
3) Ajustar quantidade e descontos (se permitido)
4) Selecionar pagamento (Dinheiro / Cartão / PIX)
5) Concluir e imprimir (qualquer impressora)
```

**4.2 Reposição de Estoque**
```
1) Módulos → Estoque
2) Registrar Entrada (ex.: número de nota/fornecedor)
3) Atualizar preços e conferir níveis críticos
```

**4.3 Rotina de Caixa**
```
1) Abrir caixa com saldo inicial
2) Registrar suprimentos e sangrias durante o dia
3) Fechar conferindo totais por meio de pagamento
```

**4.4 Emissão Fiscal (NFC-e)**
```
1) Fiscal → Configurar Nota (NFC-e) — preencher tudo
2) Testar em Homologação
3) Após validar, trocar para Produção
(As regras variam por estado — consulte sua contabilidade/SEFAZ.)
```

🟫────────────────────────────────────────────────────────────────
**5. Mensagens Comuns e Soluções**
🟫────────────────────────────────────────────────────────────────
```
“Acesso negado”
→ Falta permissão. Peça ajuste de cargo/permissões ao Administrador.

“Falha ao abrir módulo”
→ Arquivo ausente ou erro interno. Verifique se o .py existe (vendas.py, estoque.py etc.).

“PIX sem nome do recebedor”
→ Defina em Admin → Configuração PIX.
   Se vazio, usa Nome do Estabelecimento (Fiscal → Configurar Nome Nota/Recibo).
```

⬛────────────────────────────────────────────────────────────────
**6. Boas Práticas e Backup**
⬛────────────────────────────────────────────────────────────────
```
• Faça backups do arquivo erp_pdv.db com o sistema fechado.
• Cadastre usuários separados e use senhas fortes.
• Mantenha Nome do Estabelecimento e Configuração PIX atualizados.
• Revise permissões periodicamente (principalmente ao desligar colaboradores).

Local do banco: mesmo diretório do app (ou variável ERP_PDV_DB)
Backup: copie o .db para mídia segura (nuvem/dispositivo externo)
```

🔷───────────────────────────────────────────────────────────────
**7. Permissões e Cargos**
🔷───────────────────────────────────────────────────────────────
```
Cargos padrão
  • ADMIN       → acesso total
  • VENDEDOR    → PDV, Relatórios
  • GERENTE     → PDV, Estoque, Relatórios, Finanças
  • ESTOQUISTA  → Estoque, Relatórios
  • FINANCEIRO  → Finanças, Relatórios

Permissões disponíveis
  • PDV           — Módulo de Vendas
  • ESTOQUE       — Módulo de Estoque
  • RELATORIOS    — Relatórios e Dashboard
  • FINANCAS      — Finanças / Taxas
  • PIX_CONFIG    — Configuração PIX
  • ADMIN_USERS   — Administração de Usuários
  • FISCAL_CONFIG — Configurar NFC-e
  • FISCAL_EMIT   — Emitir NFC-e

Nota: permissões podem ser atribuídas diretamente ao usuário ou herdadas por cargo.
```
