# emitir_nfce_cli.py
import sys, sqlite3
from nfce_adapter import NFCeAdapter, abrir_pdf

def get_conn_factory(db_path: str):
    def _get():
        con = sqlite3.connect(db_path)
        con.row_factory = sqlite3.Row
        return con
    return _get

if __name__ == "__main__":
    if len(sys.argv) < 3:
        print("Uso: python emitir_nfce_cli.py <caminho.db> <sale_id>")
        sys.exit(1)
    db, sale_id = sys.argv[1], int(sys.argv[2])
    get_conn = get_conn_factory(db)
    resp = NFCeAdapter(get_conn).emit(sale_id)
    if resp.get("ok"):
        print("OK - chave:", resp["chave"], "status:", resp["status"], "pdf:", resp["pdf"])
        abrir_pdf(resp["pdf"])
    else:
        print("Falha:", resp)
