Set-Content -Path .\verify_taxas.py -Value @'
import sys, sqlite3, os, datetime

def fmt_money(v):
    return f"R$ {v:.2f}".replace(".", ",")

def main():
    if len(sys.argv) < 2:
        print("Uso: python verify_taxas.py <caminho_do_banco>")
        sys.exit(1)
    db = sys.argv[1]
    if not os.path.exists(db):
        print(f"Arquivo não encontrado: {db}")
        sys.exit(2)

    conn = sqlite3.connect(db)
    conn.row_factory = sqlite3.Row

    # checa se a tabela existe
    has = conn.execute(
        "SELECT 1 FROM sqlite_master WHERE type='table' AND lower(name)='taxas_cobrancas'"
    ).fetchone()
    if not has:
        print("Tabela 'taxas_cobrancas' não encontrada neste banco.")
        sys.exit(3)

    today = conn.execute("SELECT date('now','localtime') d").fetchone()["d"]
    pend = conn.execute("""
        SELECT COUNT(*) qtd, COALESCE(SUM(amount),0) tot
          FROM taxas_cobrancas
         WHERE status='PENDENTE'
           AND date(created_at)=date('now','localtime')
    """).fetchone()

    print("== Verificação de taxas ==")
    print("Banco:", db)
    print("Hoje :", today)
    print(f"Pendentes HOJE: {pend['qtd']}  Total: {fmt_money(pend['tot'])}")

    print("\nTotais por status (GERAL):")
    for r in conn.execute("""
        SELECT status, COUNT(*) qtd, COALESCE(SUM(amount),0) tot
          FROM taxas_cobrancas
         GROUP BY status
         ORDER BY status
    """):
        print(f" - {r['status']:<9}  qtd={r['qtd']:>4}  total={fmt_money(r['tot'])}")

    print("\nÚltimas 20 taxas:")
    for r in conn.execute("""
        SELECT id, status, COALESCE(amount,0) amount, sale_id, created_at
          FROM taxas_cobrancas
         ORDER BY id DESC
         LIMIT 20
    """):
        print(f"#{r['id']:>5}  {r['status']:<9}  {fmt_money(r['amount'])}  sale={r['sale_id']}  {r['created_at']}")

if __name__ == "__main__":
    main()
'@
