# reset_admin_app.py — redefine admin/admin no mesmo DB do app, sem apagar dados
import os, sqlite3
from datetime import datetime
import erp_pdv_tk as app

db = app.get_db_path()
print("DB:", db)

conn = sqlite3.connect(db)
conn.row_factory = sqlite3.Row

# garante tabela users
conn.execute("""
CREATE TABLE IF NOT EXISTS users(
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  username TEXT UNIQUE NOT NULL,
  full_name TEXT,
  password_hash TEXT NOT NULL,
  is_admin INTEGER NOT NULL DEFAULT 0,
  active INTEGER NOT NULL DEFAULT 1,
  must_change_password INTEGER NOT NULL DEFAULT 0,
  created_at TEXT NOT NULL
)
""")

row = conn.execute("SELECT id FROM users WHERE username='admin'").fetchone()
if row:
    conn.execute(
        "UPDATE users SET password_hash=?, is_admin=1, active=1, must_change_password=1 WHERE username='admin'",
        (app.make_password("admin"),)
    )
    print("Senha do admin redefinida para 'admin'. Vai pedir troca no login.")
else:
    conn.execute(
        "INSERT INTO users(username, full_name, password_hash, is_admin, active, must_change_password, created_at) "
        "VALUES (?,?,?,?,?,?,?)",
        ("admin","Administrador", app.make_password("admin"), 1, 1, 1, datetime.utcnow().isoformat())
    )
    print("Usuário 'admin' criado (senha 'admin'). Vai pedir troca no login.")

conn.commit(); conn.close()
print("OK. Agora rode o sistema e entre com admin / admin.")
