﻿# sitecustomize.py — carrega automaticamente quando o Python inicia (se o arquivo estiver no sys.path)
import sys, inspect
try:
    import tkinter.messagebox as _mb
except Exception:
    _mb = None

def _hook(kind, *args, **kwargs):
    # Mostra quem chamou (topo do stack útil)
    stack = [f"{f.filename}:{f.lineno} in {f.function}" for f in inspect.stack()[2:8]]
    print(f"[MSGBOX {kind}] args={args} kwargs={kwargs}\n  called from:\n  - " + "\n  - ".join(stack), file=sys.stderr)
    fn = getattr(_orig, kind)
    return fn(*args, **kwargs)

if _mb:
    _orig = _mb
    _mb.showwarning = lambda *a, **k: _hook("showwarning", *a, **k)
    _mb.showinfo    = lambda *a, **k: _hook("showinfo",    *a, **k)
    _mb.showerror   = lambda *a, **k: _hook("showerror",   *a, **k)
