\# Manual do Usuário 



Bem-vindo! Este manual explica, de forma objetiva e prática, como usar o ERP/PDV para \*\*vender\*\*, \*\*controlar estoque\*\*, \*\*gerir caixa\*\*, \*\*configurar o fiscal\*\* e \*\*administrar usuários\*\*.



> \*\*Dicas rápidas\*\*

>

> - Menus desabilitados indicam \*\*falta de permissão\*\*. Peça ao Administrador.

> - Atalho do manual: \*\*F1\*\*.

> - Relatórios: \*\*F11\*\* (quando habilitado).

> - O banco local é um arquivo \*\*SQLite\*\* (`erp\_pdv.db`).



---



\## Sumário



\- \[Visão Geral](#visão-geral)

\- \[Atalhos Principais](#atalhos-principais)

\- \[Menus da Tela Principal](#menus-da-tela-principal)

&nbsp; - \[Módulos](#módulos)

&nbsp;   - \[PDV (Vendas)](#pdv-vendas)

&nbsp;   - \[Estoque](#estoque)

&nbsp;   - \[Caixa (Abertura/Fechamento)](#caixa-aberturafechamento)

&nbsp;   - \[Finanças (Taxas)](#finanças-taxas)

&nbsp;   - \[Relatórios (F11)](#relatórios-f11)

&nbsp; - \[Fiscal](#fiscal)

&nbsp;   - \[Configurar Nota (NFC-e)](#configurar-nota-nfc-e)

&nbsp;   - \[Configurar Nome Nota/Recibo](#configurar-nome-notarecibo)

&nbsp; - \[Admin](#admin)

&nbsp;   - \[Usuários](#usuários)

&nbsp;   - \[Configuração PIX](#configuração-pix)

&nbsp; - \[Conta](#conta)

&nbsp;   - \[Trocar Senha](#trocar-senha)

&nbsp;   - \[Sair](#sair)

&nbsp; - \[Ajuda](#ajuda)

\- \[Fluxos de Trabalho (Passo a Passo)](#fluxos-de-trabalho-passo-a-passo)

\- \[Mensagens Comuns e Soluções](#mensagens-comuns-e-soluções)

\- \[Boas Práticas e Backup](#boas-práticas-e-backup)

\- \[Permissões e Cargos](#permissões-e-cargos)



---



\## Visão Geral



O sistema é um ERP/PDV de \*\*uso local\*\* (desktop) com interface \*\*Tkinter\*\* e banco \*\*SQLite\*\*.  

As funcionalidades são liberadas por \*\*permissões\*\* que podem ser atribuídas diretamente ao usuário ou herdadas por \*\*cargos\*\* (Admin, Vendedor, Gerente, Estoquista, Financeiro).



---



\## Atalhos Principais



| Ação                      | Atalho | Onde              |

|---------------------------|:------:|-------------------|

| Abrir Manual do Usuário   |  F1    | Qualquer tela     |

| Abrir Relatórios          |  F11   | Menu → Módulos    |



> Se um atalho não funciona, verifique se você possui permissão para aquele módulo.



---



\## Menus da Tela Principal



\### Módulos



\#### PDV (Vendas)



Tela dedicada à \*\*venda rápida\*\*: adicionar itens, aplicar descontos (se permitido), escolher \*\*forma de pagamento\*\* e \*\*emitir recibo\*\*.



\*\*Como usar\*\*

1\. Abra \*\*Módulos → PDV (Vendas)\*\*.

2\. Busque o produto por \*\*código de barras\*\*, \*\*código interno\*\* ou \*\*nome\*\*.

3\. Informe \*\*quantidade\*\* e confirme a inclusão.

4\. (Opcional) Aplique \*\*desconto\*\* por item ou no total (requer permissão).

5\. Selecione a \*\*forma de pagamento\*\* (Dinheiro / Cartão / PIX).

6\. \*\*Conclua\*\* a venda e \*\*imprima\*\* o recibo.



> \*\*Requisitos\*\*: permissão `PDV`.  

> \*\*Observação\*\*: para pagamentos via \*\*PIX\*\*, o nome do recebedor vem da \*\*Configuração PIX\*\*; caso ausente, usa o \*\*Nome do Estabelecimento\*\* do menu Fiscal → Configurar Nome Nota/Recibo.



---



\#### Estoque



Cadastro de \*\*produtos\*\* e controle de \*\*movimentações\*\* (\*\*entradas\*\*, \*\*saídas\*\* e \*\*ajustes\*\*).



\*\*Recursos\*\*

\- \*\*Produtos\*\*: nome, preço, código, unidade, NCM (quando aplicável).

\- \*\*Movimentações\*\*:  

&nbsp; - \*\*Entrada\*\* (ex.: compra/recebimento).  

&nbsp; - \*\*Saída\*\* (ex.: venda/baixa manual).  

&nbsp; - \*\*Ajuste\*\* (inventário/contagem).

\- \*\*Acompanhamento\*\* de níveis críticos e giro de estoque.



> \*\*Requisitos\*\*: permissão `ESTOQUE`.



---



\#### Caixa (Abertura/Fechamento)



Controle de \*\*movimento do dia\*\*: abertura, \*\*suprimentos\*\*, \*\*sangrias\*\* e fechamento.



\*\*Fluxo típico\*\*

1\. \*\*Abrir\*\* caixa com saldo inicial.

2\. Registrar \*\*suprimentos\*\* (entradas) e \*\*sangrias\*\* (retiradas) com observação.

3\. Ao final do expediente, \*\*fechar\*\* o caixa conferindo Dinheiro/Cartões/PIX.



> \*\*Requisitos\*\*: permissão `FINANCAS`.



---



\#### Finanças (Taxas)



Definição e simulação de \*\*taxas\*\* (cartão, PIX, outros meios).



\*\*Recursos\*\*

\- \*\*Tabela de taxas\*\* por modalidade.

\- \*\*Simulação\*\* do valor líquido esperado por venda conforme a taxa aplicada.



> \*\*Requisitos\*\*: permissão `FINANCAS`.



---



\#### Relatórios (F11)



Painel com relatórios de \*\*vendas\*\*, \*\*estoque\*\* e \*\*caixa\*\*.



\*\*Filtros comuns\*\*

\- Período (data inicial/final).

\- Usuário (operador).

\- Forma de pagamento.



\*\*Exemplos\*\*

\- \*\*Vendas por período\*\* e por forma de pagamento.

\- \*\*Produtos mais vendidos\*\* e \*\*giro de estoque\*\*.

\- \*\*Movimento de caixa\*\* (abertura, suprimentos, sangrias, fechamento).



> \*\*Requisitos\*\*: permissão `RELATORIOS`.  

> \*\*Atalho\*\*: \*\*F11\*\*.



---



\### Fiscal



\#### Configurar Nota (NFC-e)



Tela para configurar \*\*parâmetros fiscais\*\* exigidos pelo seu estado (ex.: CSC, série, ambiente de homologação/produção, certificado quando aplicável).  

Recomenda-se \*\*testar em homologação\*\* antes de emitir em produção.



> \*\*Requisitos\*\*: permissão `FISCAL\_CONFIG` (e `FISCAL\_EMIT` para emissão, quando disponível).



---



\#### Configurar Nome Nota/Recibo



Define o \*\*Nome do Estabelecimento\*\* e \*\*dados de impressão\*\* do recibo:

\- Nome (aparece no topo do recibo e como fallback do nome do recebedor PIX).

\- Endereço (linhas 1 e 2) e \*\*Cidade/UF\*\*.

\- Documento (\*\*CNPJ/CPF\*\*) para impressão.



> A configuração impacta a \*\*identidade visual do recibo\*\* e o \*\*PIX\*\* quando o nome não está definido na Configuração PIX.



---



\### Admin



\#### Usuários



Gestão de \*\*contas de usuário\*\*, \*\*cargos\*\* e \*\*permissões\*\*.



\*\*O que é possível fazer\*\*

\- \*\*Criar\*\* usuário com senha inicial (pode forçar troca no primeiro login).

\- \*\*Editar\*\* dados (nome, ativo/inativo, admin).

\- Atribuir \*\*cargos\*\* (Admin, Vendedor, Gerente, Estoquista, Financeiro).

\- Conceder \*\*permissões\*\* específicas além do cargo.

\- \*\*Redefinir senha\*\*.

\- \*\*Ativar/desativar\*\* acesso.



\*\*Proteções\*\*

\- Não é permitido \*\*excluir\*\* o usuário `admin`.

\- Não é permitido excluir o \*\*último administrador\*\* ativo.



> \*\*Requisitos\*\*: permissão `ADMIN\_USERS` ou ser \*\*Admin\*\*.



---



\#### Configuração PIX



Cadastro da \*\*chave PIX\*\*, \*\*nome do recebedor\*\* e demais parâmetros usados no QR Code.  

Se o nome do recebedor não estiver definido aqui, o sistema usa o \*\*Nome do Estabelecimento\*\* configurado em Fiscal → Configurar Nome Nota/Recibo.



> \*\*Requisitos\*\*: permissão `PIX\_CONFIG` (ou Admin).



---



\### Conta



\#### Trocar Senha



Troca a senha do \*\*usuário logado\*\*. Informe a nova senha \*\*duas vezes\*\*.  

Recomenda-se usar senhas \*\*fortes\*\* e \*\*exclusivas\*\*.



---



\#### Sair



Encerra a sessão atual e retorna à \*\*tela de login\*\*.



---



\### Ajuda



\- \*\*Manual do Usuário (F1)\*\*: abre este documento.



---



\## Fluxos de Trabalho (Passo a Passo)



\### 1) Venda Rápida no PDV

1\. Menu \*\*Módulos → PDV (Vendas)\*\*.

2\. Adicione itens por código de barras, código interno ou busca por nome.

3\. Ajuste \*\*quantidade\*\* e (se permitido) \*\*descontos\*\*.

4\. Selecione a \*\*forma de pagamento\*\* (Dinheiro/Cartão/PIX).

5\. Conclua e \*\*imprima o recibo\*\*.



\### 2) Reposição de Estoque

1\. \*\*Módulos → Estoque\*\*.

2\. Registre \*\*Entrada\*\* com a referência (ex.: número de nota/fornecedor).

3\. Atualize preços e verifique \*\*níveis críticos\*\*.



\### 3) Rotina de Caixa (Dia a Dia)

1\. \*\*Abrir caixa\*\* com saldo inicial.

2\. Registrar \*\*suprimentos\*\* (entradas) e \*\*sangrias\*\* (retiradas) durante o dia.

3\. \*\*Fechar caixa\*\* conferindo os totais por meio de pagamento.



\### 4) Emissão Fiscal (NFC-e)

1\. \*\*Fiscal → Configurar Nota (NFC-e)\*\*: preencha todos os campos.

2\. \*\*Teste\*\* em ambiente de \*\*homologação\*\*.

3\. Após validar, troque para \*\*produção\*\*.



> \*\*Importante\*\*: obrigações fiscais variam por \*\*estado\*\*. Consulte sua contabilidade/SEFAZ.



---



\## Mensagens Comuns e Soluções



\- \*\*“Acesso negado”\*\*  

&nbsp; Seu usuário não possui permissão para a funcionalidade.  

&nbsp; → Solicite ao \*\*Administrador\*\* ajuste de \*\*cargo\*\* ou \*\*permissões\*\*.



\- \*\*“Falha ao abrir módulo”\*\*  

&nbsp; O arquivo do módulo pode estar ausente ou houve erro interno.  

&nbsp; → Verifique se o arquivo Python existe (ex.: `vendas.py`, `estoque.py`) e tente novamente.



\- \*\*PIX não exibe nome correto\*\*  

&nbsp; O nome do recebedor vem de \*\*Admin → Configuração PIX\*\*.  

&nbsp; Se estiver vazio, usa o \*\*Nome do Estabelecimento\*\* (Fiscal → Configurar Nome Nota/Recibo).



---



\## Boas Práticas e Backup



\- \*\*Backups regulares\*\* do arquivo `erp\_pdv.db` com o sistema \*\*fechado\*\*.

\- \*\*Usuários separados\*\* para cada colaborador; \*\*senhas fortes\*\*.

\- Mantenha \*\*Nome do Estabelecimento\*\* e \*\*Configuração PIX\*\* atualizados.

\- Revise \*\*permissões\*\* periodicamente, especialmente ao desligar colaboradores.



> \*\*Local do banco\*\*: mesmo diretório do aplicativo (ou caminho definido pela variável de ambiente `ERP\_PDV\_DB`).  

> \*\*Backup\*\*: copie o arquivo `.db` para mídia segura (pasta na nuvem ou dispositivo externo).



---



\## Permissões e Cargos



\*\*Cargos padrão\*\*  

\- `ADMIN` — acesso total.  

\- `VENDEDOR` — foco em \*\*PDV\*\* e \*\*Relatórios\*\*.  

\- `GERENTE` — \*\*PDV\*\*, \*\*Estoque\*\*, \*\*Relatórios\*\* e \*\*Finanças\*\*.  

\- `ESTOQUISTA` — \*\*Estoque\*\* e \*\*Relatórios\*\*.  

\- `FINANCEIRO` — \*\*Finanças\*\* e \*\*Relatórios\*\*.



\*\*Permissões disponíveis\*\*  

\- `PDV` — Módulo de Vendas (PDV)  

\- `ESTOQUE` — Módulo de Estoque  

\- `RELATORIOS` — Relatórios e Dashboard  

\- `FINANCAS` — Finanças / Taxas da plataforma  

\- `PIX\_CONFIG` — Configuração PIX  

\- `ADMIN\_USERS` — Administração de Usuários  

\- `FISCAL\_CONFIG` — Configurar NFC-e  

\- `FISCAL\_EMIT` — Emitir NFC-e



> As permissões podem ser atribuídas \*\*diretamente\*\* ao usuário ou \*\*herdadas\*\* via cargo.



