# verify-taxas.ps1
param(
  # Ajuste o caminho do seu banco aqui:
  [string]$DbPath = "$PSScriptRoot\erp.db"   # exemplo: "C:\Users\seuuser\Documents\erp_pdv_tk\erp.db"
)

Write-Host "Banco: $DbPath" -ForegroundColor Cyan
if (-not (Test-Path $DbPath)) {
  Write-Error "Arquivo de banco não encontrado. Ajuste o parâmetro -DbPath."
  exit 1
}

# Procura o sqlite3.exe no PATH
$sqlite = Get-Command sqlite3 -ErrorAction SilentlyContinue
if (-not $sqlite) {
  Write-Error "sqlite3.exe não encontrado no PATH.
Instale com:  winget install SQLite.sqlite  (ou use o sqlite-tools da sqlite.org)
Depois rode novamente este script."
  exit 1
}

# SQL de verificação
$sql = @"
-- Data de referência
SELECT date('now','localtime') AS hoje;

-- Pendências de HOJE
SELECT COUNT(*) AS pendentes_hoje,
       printf('R$ %.2f', COALESCE(SUM(amount),0)) AS total_hoje
FROM taxas_cobrancas
WHERE status='PENDENTE'
  AND date(created_at)=date('now','localtime');

-- Totais por status (geral)
SELECT status,
       COUNT(*) AS qtd,
       printf('R$ %.2f', COALESCE(SUM(amount),0)) AS total
FROM taxas_cobrancas
GROUP BY status
ORDER BY status;

-- Últimas 20 taxas (para inspeção)
SELECT id, status,
       printf('R$ %.2f', COALESCE(amount,0)) AS amount,
       sale_id, created_at
FROM taxas_cobrancas
ORDER BY id DESC
LIMIT 20;
"@

# Executa e mostra formatado em colunas
$sql | & $sqlite.Source -header -column $DbPath
